ALTER TABLE ejf_section ADD filter VARCHAR(10);
ALTER TABLE ejf_section ADD caton CHAR(1) DEFAULT 'T';
ALTER TABLE ejf_section ADD ruleon CHAR(1) DEFAULT 'T';
ALTER TABLE ejf_section ADD logo VARCHAR(100);
ALTER TABLE ejf_section ADD showHotlinks VARCHAR(10);
ALTER TABLE ejf_section ADD hotlinkRows TINYINT DEFAULT 8;
ALTER TABLE ejf_section ADD isOnBoard CHAR(1) DEFAULT 'F';
ALTER TABLE ejf_section ADD imageMode CHAR(1) DEFAULT 'P';
ALTER TABLE ejf_section ADD imageFile VARCHAR(255);
ALTER TABLE ejf_section ADD imageLink VARCHAR(255);
ALTER TABLE ejf_section ADD imageTitle VARCHAR(255);
ALTER TABLE ejf_section ADD headAdCode LONGVARCHAR;
ALTER TABLE ejf_section ADD footAdCode LONGVARCHAR;

ALTER TABLE ejf_board ADD isCatOK CHAR(1) DEFAULT 'F';
ALTER TABLE ejf_board ADD listType VARCHAR(10);
ALTER TABLE ejf_board ADD cats VARCHAR(255);
ALTER TABLE ejf_board ADD members LONGVARCHAR;
ALTER TABLE ejf_board ADD topicAdCode LONGVARCHAR;
ALTER TABLE ejf_board ADD scoreType CHAR(1) DEFAULT 'N';
ALTER TABLE ejf_board ADD iconFile VARCHAR(100);

ALTER TABLE ejf_topic ADD catID TINYINT DEFAULT 0;
ALTER TABLE ejf_topic ALTER COLUMN highColor VARCHAR(8);
ALTER TABLE ejf_topic ADD specType CHAR(1) DEFAULT 'N';
ALTER TABLE ejf_topic ADD diggups INT DEFAULT 0;
ALTER TABLE ejf_topic ADD diggdns INT DEFAULT 0;

ALTER TABLE ejf_archive_topic ADD catID TINYINT DEFAULT 0;
ALTER TABLE ejf_archive_topic ALTER COLUMN highColor VARCHAR(8);
ALTER TABLE ejf_archive_topic ADD specType CHAR(1) DEFAULT 'N';
ALTER TABLE ejf_archive_topic ADD diggups INT DEFAULT 0;
ALTER TABLE ejf_archive_topic ADD diggdns INT DEFAULT 0;

CREATE INDEX ejf_topic_list ON ejf_topic (boardID,sectionID,state,topScope,catID);

CREATE CACHED TABLE ejf_tags (
    tagname         VARCHAR(20)     NOT NULL,
    queryCount    	INT  	    DEFAULT 1,
    recordCount    	INT  	    DEFAULT 0,
    createTime      DATETIME,
    updateTime      TIMESTAMP,
    PRIMARY KEY (tagname));

CREATE TABLE ejf_feed_stat (
    boardID      	VARCHAR(10)		NOT NULL,
    visits          INT             DEFAULT 1,
    createTime      DATETIME,
    PRIMARY KEY(boardID));

CREATE CACHED TABLE ejf_vote(
    topicID         INT             NOT NULL,
    options    		LONGVARCHAR		NOT NULL,
    voters 	        LONGVARCHAR     ,
    isPublic		CHAR(1) 		DEFAULT 'T',
    isSingle		CHAR(1) 		DEFAULT 'T',
	expireDate		DATETIME		,
    FOREIGN KEY(topicID)
        REFERENCES ejf_topic(topicID) ON DELETE CASCADE);
        
CREATE CACHED TABLE ejf_voting(
    topicID         INT             NOT NULL,
    optID			INT    			NOT NULL,
    optCount		INT    			DEFAULT 0,
    updateTime      TIMESTAMP,
    FOREIGN KEY(topicID)
        REFERENCES ejf_topic(topicID) ON DELETE CASCADE);

CREATE TABLE ejf_deposit(
    userID          VARCHAR(15)     NOT NULL,
    createTime      DATETIME 		NOT NULL,
    deposit         INT             DEFAULT 0);
